**********************************************************************
*This program use combined household-level SIH data and estiamted redraw 
*Produce data for Figure 7, 8, 9, 10, 11 and 14
**********************************************************************
clear
use  "$path\data\2004_2018.dta"

*merge with estimated redraw value

sort abshid
merge 1:1 abshid year using "$path\data\redraw.dta", nogen


su hh_redraw, de
replace hh_redraw=. if hh_redraw>1000000 & hh_redraw!=. //get rid of outliers 

drop if year==2008 

replace off=0 if off==.

*replace negative values with zero
replace dinc=0 if dinc<0
replace dinc=0 if dinc==.
replace debts=0 if debts<0

*Based on whole household 
g retired = (superinc > 0)
g retired_super=0
replace retired_super=super if retired==1

*Annual disposable income
g adinc = dinc*52


*Household size 
g hsize = adults+children


********household liquidity buffer***********

*Baseline buffer: Liquid assets //bank is sum of offset and deposit 
g liqassets = bank + shares + bonds +trust
gen buffer=liqassets/adinc*12
summarize buffer, detail
replace buffer=. if buffer>200

*Buffer excludes offset
g liqassets_nooff = bank + shares + bonds +trust - off if year>2010 //we only see offset separately after 2010/2011 
g buffer_nooff=liqassets_nooff/adinc*12 
replace buffer_nooff=. if buffer_nooff>200 

*Buffer includes estimated redraw 
gen liqassets_redraw=liqassets+hh_redraw
gen buffer_re=liqassets_redraw/adinc*12
replace buffer_re=. if buffer_re>200
  

*Liquid debt (credit card debt)
g liq_debt = ccdebt 

*Liquid net wealth 
g liqnw = liqassets - liq_debt

*liquid net wealth with redraw
g liqnw_re=liqassets_redraw - liq_debt

* housing equity, including investments 
g house_equity = resassets - resdebt

*Illiquid net wealth 
g illiqnw = house_equity + super

*Set fortnightly household income
*g pay = dinc_prev/26
g pay = dinc*52/26

*Set household credit limit to one month of income (from Kaplan)
g credit_limit = dinc*52/12

*HTM households 
g htm=0
replace htm=1 if (pay/2>=liqnw & liqnw>=0)
replace htm=1 if (pay/2-credit_limit>=liqnw & liqnw<=0)

g wealthy_htm= (htm==1 & illiqnw>0)
g poor_htm= ( htm==1 & illiqnw<=0)


*********DTI***********
*gross DTI
gen dti=debts/adinc 
*net DTI 
gen net_dti=(debts-liqassets)/adinc

*net DTI net of liquid assets (including redraw)
gen net_dti_re=(debts-liqassets_redraw)/adinc 

*housing DTI
gen dti_mort=hdebt/adinc 
* housing dti net of liquid assets (including redraw)
gen net_dti_mort_re=(hdebt-liqassets_redraw)/adinc 



*outright owners 
gen outright_owner=0
replace outright_owner=1 if mortgagor==0 & owner==1


*loan birth cohorts 
gen loan_after2010=1 if year_loan_originated>=2010
replace loan_after2010=0 if year_loan_originated<2010
replace loan_after2010=. if year_loan_originated==. 


*******************************************
*RDP figrues data 
*******************************************
*Figure 7: Household Liquid assets, time series 
g bank_dinc=bank/dinc_month
g share_dinc=shares/dinc_month
g bond_dinc=bonds/dinc_month
g trust_dinc=trust/dinc_month 
g retired_super_dinc=retired_super/dinc_month 
tabstat  bank_dinc share_dinc bond_dinc trust_dinc retired_super_dinc  [aw=hwt] by(year) 

*Figure 8: Household Liquid assets,  aggregate liquid assets for renters, mortgagors, outright owners 
collapse(sum) liqassets adinc [aw=hwt], by(year renter mortgagor outright)
buffer=liqassets/adinc 

*Figure 9: Hand-to-mouth Households, share of all hosueholds
tabstat wealthy_htm poor_htm [aw=hwt] , by(year)

*Figure 10: Hand-to-mouth Households, share of all households by housing tenure 
tabstat htm [aw=hwt] if outright_owner==1, by(year)
tabstat htm [aw=hwt] if mortgagor==1, by(year)
tabstat htm [aw=hwt] if renter==1, by(year)

*Figure 11: Household Liquid assets, indebted owners, by offset accoutns 
tabstat buffer buffer_re [aw=hwt] if mortgagor==1 &off==0, by(year)
tabstat buffer buffer_re [aw=hwt] if mortgagor==1 &off>0 &off!=. , by(year)




*Figure 14: Household liquid assets, renter's aggregate buffers, average over the two decades, by young (<40) and old(>40) households 
gen after2010=1 if year>=2010
replace after2010=0 if year<2010
gen young=1 if age<=40
replace young=0 if age>40
keep if renter==1
collapse(mean) buffer [aw=hwt], by(young after2010)






